/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.access.api.AcaClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.AccUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class AccRemoveCfg {
    private String m_targetType = null;
    private String m_targetName = null;

    private void askConfirmation(String string) {
        String string2 = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ACC_ROLE_DELETE_CONFIRM");
        string2 = MessageFormat.format(string2, string);
        AccUtils.SHOW(string2);
    }

    private void askForReenter() {
        String string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ACC_PLEASE_REENTER_01");
        AccUtils.SHOW(string);
    }

    private void removeTargetFromACMServer() {
        AccUtils.DBG("Entering:AccRemoveCfg::removeTargetFromACMServer ...");
        try {
            Object object;
            int n = 0;
            String[] stringArray = new String[]{this.m_targetName};
            AccUtils.DBG("Target Name = " + this.m_targetName);
            if (this.m_targetName.length() <= 0) {
                AccUtils.throwInvalidParmValue("-n");
            }
            AcaClient acaClient = new AcaClient(1);
            if (this.m_targetType.equals("taskrole")) {
                object = acaClient.GetUsers(1, this.m_targetName);
                if (object != null) {
                    String string = new String();
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        string = ((String[])object).length == 1 || i == ((String[])object).length - 1 ? string + object[i] : string + object[i] + ",";
                    }
                    this.askConfirmation(string);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    String string2 = bufferedReader.readLine().trim();
                    while (!string2.equalsIgnoreCase("0") && !string2.equalsIgnoreCase("1")) {
                        this.askForReenter();
                        string2 = bufferedReader.readLine().trim();
                    }
                    AccUtils.DBG("userResponse = " + string2);
                    if (string2.equalsIgnoreCase("1")) {
                        n = acaClient.DeleteRole(this.m_targetName);
                    } else if (string2.equalsIgnoreCase("0")) {
                        AccUtils.DBG("User Entered not to delete the Role. Hence exiting from here");
                        AccUtils.DBG("Exiting:AccRemoveCfg::removeTargetFromACMServer ...");
                        return;
                    }
                } else {
                    n = acaClient.DeleteRole(this.m_targetName);
                }
            } else if (this.m_targetType.equals("resourcerole")) {
                object = acaClient.GetUsers(2, this.m_targetName);
                if (object != null) {
                    String string = new String();
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        string = ((String[])object).length == 1 || i == ((String[])object).length - 1 ? string + object[i] : string + object[i] + ",";
                    }
                    this.askConfirmation(string);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    String string3 = bufferedReader.readLine().trim();
                    while (!string3.equalsIgnoreCase("0") && !string3.equalsIgnoreCase("1")) {
                        this.askForReenter();
                        string3 = bufferedReader.readLine().trim();
                    }
                    AccUtils.DBG("userResponse = " + string3);
                    if (string3.equalsIgnoreCase("1")) {
                        n = acaClient.DeleteGroup(this.m_targetName);
                    } else if (string3.equalsIgnoreCase("0")) {
                        AccUtils.DBG("User Entered not to delete the Group. Hence exiting from here");
                        AccUtils.DBG("Exiting:AccRemoveCfg::removeTargetFromACMServer ...");
                        return;
                    }
                } else {
                    n = acaClient.DeleteGroup(this.m_targetName);
                }
            } else if (this.m_targetType.equals("resource")) {
                n = acaClient.PurgeResources(2, stringArray);
            }
            AccUtils.DBG("Return code=" + n);
            if (n != 0) {
                object = AcaClient.GetMessage((int)n);
                AccUtils.SHOW((String)object);
                System.exit(AccUtils.FAILURE);
            } else {
                AccUtils.DBG("targetType = " + this.m_targetType + " targetName = " + this.m_targetName + " is removed successfully from AcmServer");
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            AccUtils.SHOW(exception.getMessage());
            AccUtils.DBG("Exiting:AccRemoveCfg::removeTargetFromACMServer ...");
            System.exit(1);
        }
        AccUtils.DBG("Exiting:AccRemoveCfg::removeTargetFromACMServer ...");
    }

    public void performCommand() throws PIHscClientException, RequiredParameterException {
        this.removeTargetFromACMServer();
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException, RequiredParameterException {
        String string = null;
        int n = 0;
        AccUtils.DBG("In mapParameters");
        this.m_targetType = (String)hashMap.get("-t");
        this.m_targetName = (String)hashMap.get("-n");
        if (this.m_targetType == null || !this.m_targetType.equals("taskrole") && !this.m_targetType.equals("resource") && !this.m_targetType.equals("resourcerole")) {
            Object[] objectArray = new String[]{"-t"};
            string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", null, objectArray);
            throw new RequiredParameterException(string);
        }
        this.m_targetType = this.m_targetType.trim();
        ++n;
        if (this.m_targetName == null) {
            Object[] objectArray = new String[]{"-n"};
            string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", null, objectArray);
            throw new RequiredParameterException(string);
        }
        this.m_targetName = this.m_targetName.trim();
        AccUtils.DBG("commandParameter=" + hashMap);
        AccUtils.DBG("count=" + ++n);
        HMCCommandUtils.checkParameterCount(hashMap, n);
    }

    public void printHelp() {
        AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "ACCRMCFG_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        AccRemoveCfg accRemoveCfg = new AccRemoveCfg();
        try {
            String string2 = null;
            if (stringArray.length == 0) {
                accRemoveCfg.printHelp();
                bl = true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                arrayList.add(string2);
                if (!string2.equals("--help")) continue;
                accRemoveCfg.printHelp();
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                accRemoveCfg.mapParameters(hashMap);
                accRemoveCfg.performCommand();
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                pIHscClientException.printStackTrace();
            }
            if ((string = pIHscClientException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            string = requiredParameterException.getMessage();
            AccUtils.SHOW(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            AccUtils.SHOW(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

